/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDisplayModel
implements DisplayModel {
    protected Dimension fDisplayDimension = new Dimension(1, 1);
    protected DisplayElement[][] fDisplayElements;
    private List fDisplayModelListeners;
    protected boolean fModifying;

    public AbstractDisplayModel(Dimension displayDimension) {
        this.fDisplayDimension = displayDimension;
        this.fDisplayElements = new DisplayElement[this.fDisplayDimension.width][this.fDisplayDimension.height];
    }

    public Dimension getDisplayDimension() {
        return new Dimension(this.fDisplayDimension);
    }

    public void addDisplayModelListener(DisplayModelListener displayModelListener) {
        if (!this.getDisplayModelListeners().contains(displayModelListener)) {
            this.getDisplayModelListeners().add(displayModelListener);
        }
    }

    public void removeDisplayModelListener(DisplayModelListener displayModelListener) {
        this.getDisplayModelListeners().remove(displayModelListener);
    }

    public List getDisplayModelListeners() {
        if (this.fDisplayModelListeners == null) {
            this.fDisplayModelListeners = new ArrayList(5);
        }
        return this.fDisplayModelListeners;
    }

    protected void fireModelChangedEvent() {
        this.fireModelChangedEvent(new DisplayModelEvent(this));
    }

    protected void fireModelChangedEvent(DisplayModelEvent displayModelEvent) {
        if (this.fModifying) {
            return;
        }
        if (this.getDisplayModelListeners().isEmpty()) {
            return;
        }
        ArrayList clone = new ArrayList(this.fDisplayModelListeners);
        for (DisplayModelListener listener : clone) {
            listener.displayModelChanged(displayModelEvent);
        }
    }

    public boolean isModifying() {
        return this.fModifying;
    }

    public void setModifying(boolean modifying) {
        this.fModifying = modifying;
    }

    public boolean isCellEditable(Point location) {
        DisplayElement displayElement = this.getElementAt(location);
        if (displayElement == null) {
            return true;
        }
        return displayElement.isEditable();
    }

    public void setDisplayDimension(Dimension displayDimension) {
        if (this.fDisplayDimension.equals(displayDimension)) {
            return;
        }
        this.setModifying(true);
        DisplayElement[][] newElements = new DisplayElement[displayDimension.width][displayDimension.height];
        for (int x = 0; x < Math.min(this.fDisplayDimension.width, displayDimension.width); ++x) {
            for (int y = 0; y < Math.min(this.fDisplayDimension.height, displayDimension.height); ++y) {
                newElements[x][y] = this.fDisplayElements[x][y] == null ? null : (x + this.fDisplayElements[x][y].getWidth() <= displayDimension.width && y + this.fDisplayElements[x][y].getHeight() <= displayDimension.height ? this.fDisplayElements[x][y] : null);
            }
        }
        this.fDisplayElements = newElements;
        this.fDisplayDimension = displayDimension;
        this.setModifying(false);
        this.fireModelChangedEvent(new DisplayModelEvent(this, 1));
    }

    public DisplayElement getElementAt(Point location) {
        Point elementLocation = this.getElementBounds(location).getLocation();
        return this.fDisplayElements[elementLocation.x][elementLocation.y];
    }

    public Rectangle getElementBounds(Point location) {
        DisplayElement element = this.fDisplayElements[location.x][location.y];
        if (element != null) {
            Rectangle bounds = new Rectangle(location, new Dimension(element.getWidth(), element.getHeight()));
            return bounds;
        }
        for (int x = 0; x < this.fDisplayDimension.width; ++x) {
            for (int y = 0; y < this.fDisplayDimension.height; ++y) {
                Rectangle bounds;
                element = this.fDisplayElements[x][y];
                if (element == null || !(bounds = new Rectangle(new Point(x, y), new Dimension(element.getWidth(), element.getHeight()))).contains(location)) continue;
                return bounds;
            }
        }
        return new Rectangle(location.x, location.y, 1, 1);
    }

    public List getCellsElements(List cells) {
        ArrayList<DisplayElement> elements = new ArrayList<DisplayElement>(cells.size());
        for (Point cell : cells) {
            elements.add(this.getElementAt(cell));
        }
        return elements;
    }

    protected boolean canPut(DisplayElement displayElement, Point destination) {
        if (destination == null) {
            return false;
        }
        if (!new Rectangle(new Point(0, 0), this.fDisplayDimension).contains(destination)) {
            return false;
        }
        if (displayElement == null) {
            return true;
        }
        return displayElement.getWidth() + destination.x <= this.fDisplayDimension.width && displayElement.getHeight() + destination.y <= this.fDisplayDimension.height;
    }
}

